function [NM,Mmean,Pm,Mmean1,Pm1,Fp,Mk]=Torque(A,snizeni,snizeni2,cesta)
clc
%% MOTOR TATRA 928-30
a=A;                                    % Otky [1/min]
omgm=2*pi*a/60;                         % hlov rychlost [rad/s]
patm=0.1;                               % Atmosferick tlak [MPa]

p=xlsread(cesta,num2str(a),'a3:b722'); % Tlak ve vlci [bar]
p=[p(:,1),circshift(p(:,2)/10,[180,0])];% Tlak ve vlci [MPa]

alfa=0:1:719;                           % Natoen klikov hdele
alfarad=alfa*pi/180;
Dp=120;                                 % Prmr pstu [mm]
Z=140;                                  % Zdvih [mm]
Rk=Z/2;                                 % Polomr kliky [mm]
Lo=260;                                 % Dlka ojnice [mm]
lambda=Rk/Lo;                           % Klikov pomr
epsilon=17.1;                           % Kompresn pomr
iv=8;                                   % Poet vlc
Sp=pi*Dp^2/4;                           % Plocha pstu [mm^2]
Vz=Sp*Z/1000;                           % Zdvihov objem [cm^3]
Vk=Vz/(epsilon-1);                      % Kompresn objem [cm^3]
Vm=Vz*iv;                               % Objem motoru [cm^3]

%% Redukce 
moj=3.5;                                % Hmotnost ojnice [kg]
mA=1.050;                               % Redukovan hmotnost do pstnho epu [kg]
mB=2.45;                                % Redukovan hmotnost do ojninho epu [kg]
mcel=3.1;                               % Celkov hmotnost pstn skupiny [kg]
mp=mcel+mA;                             % Celkov redukovan hmotnost posuvnch st [kg] 

%% Prbh v ase dle otek
NM.nI2=a/60;                            % Otky motoru[1/s]
NM.fpul=NM.nI2*4;                       % Frekvence vzncen [Hz]
NM.Tpul=1/NM.fpul;                      % Perioda mezi jednotlivmi vzncenmi [s]
NM.fpulv=NM.nI2/2;                      % Frekvence vzncen jednoho vlce [Hz]
NM.Tpulv=1/NM.fpulv;                    % Perioda vzncen jednoho vlce [s]
vt=(0:NM.Tpulv/719:NM.Tpulv)';          % Vektor asu jedn periody vlce [s]

%% Vpoet sil
%sly psobc na pstn ep
Fp=Sp*(p(:,2)-patm)/1000;               % Sla od tlaku plynu [kN]            !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
Fsp=((mp*(Rk/1000*omgm^2*(cos(alfarad)+lambda*(cos(2*alfarad)))))/1000)'; % Setravan sla posuvnch st
Fcp=Fp-Fsp;                             % Celkov sla psobc v ose vlce [kN]
betarad=asin(lambda*sin(alfarad));      % hel beta [rad]
Fo=Fcp./cos((betarad)');                % Sla psobc v ojnici [kN]
Fb=Fcp.*tan((betarad)');                % Sla psobc od stny vlce [kN]
%sly psobc na ojnin ep
Ft=Fo.*sin((alfarad+betarad)');        % Tangenciln sla [kN]
Fr=Fo.*cos((alfarad+betarad)');        % Radiln sla [kN]
% Kroutc moment
Mk=(Rk*Ft)';                            % Kroutc moment [Nm]

%% Posunut prbh momentu dle zpalu 
posun=(length(Mk)*NM.Tpul/NM.Tpulv);    % Posun dle zaplen [poet dat]

NM.V1t=vt;                             % Vektor asu [s]
NM.V1v=circshift(Mk, [0, -4*posun]);   % Hodnoty momentu s fazovm posunem [Nm]
NM.V2t=vt;                             % Vektor asu [s]
NM.V2v=circshift(Mk, [0, 2*posun]);    % Hodnoty momentu s fazovm posunem [Nm]
NM.V3t=vt;                             % Vektor asu [s]
NM.V3v=circshift(Mk, [0, -2*posun]);    % Hodnoty momentu s fazovm posunem [Nm]
NM.V4t=vt;                             % Vektor asu [s]
NM.V4v=circshift(Mk, [0, 0*posun]);    % Hodnoty momentu s fazovm posunem [Nm]
NM.V5t=vt;                             % Vektor asu [s]
NM.V5v=circshift(Mk, [0, 1*posun]);    % Hodnoty momentu s fazovm posunem [Nm]
NM.V6t=vt;                             % Vektor asu [s]
NM.V6v=circshift(Mk, [0, -1*posun]);      % Hodnoty momentu s fazovm posunem [Nm]
NM.V7t=vt;                             % Vektor asu [s]
NM.V7v=circshift(Mk, [0, 3*posun]);    % Hodnoty momentu s fazovm posunem [Nm]
NM.V8t=vt;                             % Vektor asu [s]
NM.V8v=circshift(Mk, [0, -3*posun]);   % Hodnoty momentu s fazovm posunem [Nm]

% Vpoet celkovho kroutcho momentu
Mc=0;                                   % Poten celkov moment [Nm]
b=[0 90 180 270 360 450 540 630];       % Fzov natoen [poet hodnot]
for i=b;
    Mc=Mc+circshift(Mk, [0, i]);        % Vpoet celkovho momentu [Nm] 
end

Mmean=mean(Mc);                          % Prmrn kroutc moment [Nm]
Pm=Mmean*omgm/1000;                     % Stedn vkon motoru [kW]

%% Moment pro nulovou dvku paliva
sni=snizeni;
sni2=snizeni2;

zp=p(:,2);
zMk1=zp(1:360,1);
zMk1=flipud(zMk1);

rr=zMk1(1:180,1);
% sni=60; % snen o x %
hodsni=1-(sni/100);
x1=(1-hodsni)^(1/2);
vekkor=-x1:(2*x1/179):x1;
korekce=(vekkor.^2)+hodsni;
rr2=rr.*korekce';
zMk1(1:180)=rr2;

zp(361:720,1)=zMk1;

yp=zp;
y1=yp(271:450,1);
% sni2=50; % snen o x %
hodsni2=1-(sni2/100);
x2=(1-hodsni2)^(1/2);
vekkor2=-x2:(2*x2/179):x2;
korekce2=(vekkor2.^2)+hodsni2;
rr3=y1.*korekce2';
yp(271:450,1)=rr3;

%% Vpoet sil

p(:,2)=yp;% Tlak ve vlci [MPa]
%sly psobc na pstn ep
Fp=Sp*(p(:,2)-patm)/1000;               % Sla od tlaku plynu [kN]            !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
Fsp=((mp*(Rk/1000*omgm^2*(cos(alfarad)+lambda*(cos(2*alfarad)))))/1000)'; % Setravan sla posuvnch st
Fcp=Fp-Fsp;                             % Celkov sla psobc v ose vlce [kN]
betarad=asin(lambda*sin(alfarad));      % hel beta [rad]
Fo=Fcp./cos((betarad)');                % Sla psobc v ojnici [kN]
Fb=Fcp.*tan((betarad)');                % Sla psobc od stny vlce [kN]
%sly psobc na ojnin ep
Ft=Fo.*sin((alfarad+betarad)');        % Tangenciln sla [kN]
Fr=Fo.*cos((alfarad+betarad)');        % Radiln sla [kN]
% Kroutc moment
Mk0=(Rk*Ft)';

%% Posunut prbh momentu dle zpalu (S nulovou dvkou paliva)
NM.V1vb=circshift(Mk0, [0, -4*posun]);   % Hodnoty momentu s fazovm posunem [Nm]
NM.V2vb=circshift(Mk0, [0, 2*posun]);    % Hodnoty momentu s fazovm posunem [Nm]
NM.V3vb=circshift(Mk0, [0, -2*posun]);    % Hodnoty momentu s fazovm posunem [Nm]
NM.V4vb=circshift(Mk0, [0, 0*posun]);    % Hodnoty momentu s fazovm posunem [Nm]
NM.V5vb=circshift(Mk0, [0, 1*posun]);    % Hodnoty momentu s fazovm posunem [Nm]
NM.V6vb=circshift(Mk0, [0, -1*posun]);      % Hodnoty momentu s fazovm posunem [Nm]
NM.V7vb=circshift(Mk0, [0, 3*posun]);    % Hodnoty momentu s fazovm posunem [Nm]
NM.V8vb=circshift(Mk0, [0, -3*posun]);   % Hodnoty momentu s fazovm posunem [Nm]

% Vpoet celkovho kroutcho momentu
Mc0=0;                                   % Poten celkov moment [Nm]
b=[0 90 180 270 360 450 540 630];       % Fzov natoen [poet hodnot]
for i=b;
    Mc0=Mc0+circshift(Mk0, [0, i]);        % Vpoet celkovho momentu [Nm] 
end

Mmean1=mean(Mc0);                          % Prmrn kroutc moment [Nm]
Pm1=Mmean1*omgm/1000;                     % Stedn vkon motoru [kW]

end

