function Program_MOTOR(vstpar)

global F1 fullFileName defaultName MOM1 MOM2 MOM3 MOM4 MOM5 MOM6 MOM7 MOM8 OCH OT OCHZ Edit1 Edit2 Edit3 Edit4 Edit5 Edit6 Edit7 Edit8 Edit9 Edit10 Edit11 Edit12 Edit13 t3 t4 t2
   

if nargin==0

F1=figure('Position',[100 100 1480 768],'Name', 'Input Diesel Engine',... % horni kraj 8 pixel
        'NumberTitle','off','Units','Pixels','Tag','Figure1',...
        'Color','white','Visible','on',...
        'NumberTitle','off','Resize','off','Menubar','none'); 

%% Default
defaultName='C:\Users\Pavel\Documents\MATLAB\Tatra_pos\Virtual_model_SV';
    
MOM1=zeros(13,720,2); 
MOM2=zeros(13,720,2);  
MOM3=zeros(13,720,2); 
MOM4=zeros(13,720,2);  
MOM5=zeros(13,720,2);  
MOM6=zeros(13,720,2);  
MOM7=zeros(13,720,2);  
MOM8=zeros(13,720,2);  

OCH=zeros(2,13);
OCHZ=zeros(2,13);
OT=zeros(1,13);
    

%% Pictures        
    % Picture
    I=imread('obr.bmp');
        o1=subplot('Position',[0.1 0.1 0.3 0.3]);
        image(I);
        axis off;
        setpixelposition(o1,[385 130 865 516]);    
    
%% Frames
    %Frame 1
    r1=uicontrol('Style','frame','Units','Normalized',...
        'Position',[0.01 0.04 0.146 0.87],'Tag','frame1',...
        'BackgroundColor',[100/255 100/255 100/255]);
        setpixelposition(r1,[10 10 190 750]);

%% TEXT

    %TEXT1 
    t2=uicontrol('Units','Normalized','Style','Text','HorizontalAlignment','left',...
        'Position',[0.01 0.015 0.15 0.03],'String','Torsion crank mechanism model','Tag','text2',...
        'ForegroundColor',[0 0 0],'BackgroundColor',[255/255 255/255 255/255],...
        'FontWeight','bold','Fontsize',25);
        setpixelposition(t2,[550 720 580 40]); 
    %TEXT2 
    t3=uicontrol('Units','Normalized','Style','Text','HorizontalAlignment','left',...
        'Position',[0.01 0.015 0.15 0.03],'String','Torsion Stiffnes [Nm/rad]','Tag','text3',...
        'ForegroundColor',[0 0 0],'BackgroundColor',[255/255 255/255 255/255],...
        'FontWeight','bold','Fontsize',14);
        setpixelposition(t3,[400 650 380 30]); 
    %TEXT3 
    t4=uicontrol('Units','Normalized','Style','Text','HorizontalAlignment','left',...
        'Position',[0.01 0.015 0.15 0.03],'String','Moments of Inertia  [kg m^2]','Tag','text4',...
        'ForegroundColor',[0 0 0],'BackgroundColor',[255/255 255/255 255/255],...
        'FontWeight','bold','Fontsize',14);
        setpixelposition(t4,[325 120 380 30]);
        
    %TEXT4 F1
    t5=uicontrol('Units','Normalized','Style','Text','HorizontalAlignment','left',...
        'Position',[0.01 0.015 0.15 0.03],'String','f1','Tag','text5',...
        'ForegroundColor',[0 0 0],'BackgroundColor',[100/255 100/255 100/255],...
        'FontWeight','bold','Fontsize',28);
        setpixelposition(t5,[20 459+2-100 120 45]);
    %TEXT5 F2
    t6=uicontrol('Units','Normalized','Style','Text','HorizontalAlignment','left',...
        'Position',[0.01 0.015 0.15 0.03],'String','f2','Tag','text6',...
        'ForegroundColor',[0 0 0],'BackgroundColor',[100/255 100/255 100/255],...
        'FontWeight','bold','Fontsize',28);
        setpixelposition(t6,[20 459+2-150 120 45]);
    %TEXT6 F3
    t7=uicontrol('Units','Normalized','Style','Text','HorizontalAlignment','left',...
        'Position',[0.01 0.015 0.15 0.03],'String','f3','Tag','text7',...
        'ForegroundColor',[0 0 0],'BackgroundColor',[100/255 100/255 100/255],...
        'FontWeight','bold','Fontsize',28);
        setpixelposition(t7,[20 459+2-200 120 45]);
    %TEXT7 F4
    t8=uicontrol('Units','Normalized','Style','Text','HorizontalAlignment','left',...
        'Position',[0.01 0.015 0.15 0.03],'String','f4','Tag','text8',...
        'ForegroundColor',[0 0 0],'BackgroundColor',[100/255 100/255 100/255],...
        'FontWeight','bold','Fontsize',28);
        setpixelposition(t8,[20 459+2-250 120 45]);
        
    %TEXT8 F5
    t9=uicontrol('Units','Normalized','Style','Text','HorizontalAlignment','left',...
        'Position',[0.01 0.015 0.15 0.03],'String','f5','Tag','text9',...
        'ForegroundColor',[0 0 0],'BackgroundColor',[100/255 100/255 100/255],...
        'FontWeight','bold','Fontsize',28);
        setpixelposition(t9,[20 459+2-300 120 45]);
    %TEXT9 F6
    t10=uicontrol('Units','Normalized','Style','Text','HorizontalAlignment','left',...
        'Position',[0.01 0.015 0.15 0.03],'String','f6','Tag','text10',...
        'ForegroundColor',[0 0 0],'BackgroundColor',[100/255 100/255 100/255],...
        'FontWeight','bold','Fontsize',28);
        setpixelposition(t10,[20 459+2-350 120 45]);
    
    %TEXT10 
    t11=uicontrol('Units','Normalized','Style','Text','HorizontalAlignment','center',...
        'Position',[0.01 0.015 0.15 0.03],'String','The natural frequency [Hz]','Tag','text11',...
        'ForegroundColor',[0 0 0],'BackgroundColor',[100/255 100/255 100/255],...
        'FontWeight','bold','Fontsize',14);
        setpixelposition(t11,[20 459+2-50 180 45]);
    
    
%% Push
    % CLOSE
    h1=uicontrol('Style','push','String','CLOSE',...
        'Units','Normalized','Position',[0.013 0.045 0.14 0.06],...
        'Callback','Program_MOTOR close','Tag','close',...
        'FontWeight','bold','Fontsize',15);
        setpixelposition(h1,[15 9+5 180 45]);
    % LOAD
    h2=uicontrol('Style','push','String','LOAD DATA',...
        'Units','Normalized','Position',[0.013 0.4 0.14 0.06],...
        'Callback','Program_MOTOR load','Tag','load',...
        'FontWeight','bold','Fontsize',15);
        setpixelposition(h2,[15 459+2+250 180 45]);
    % SAVE 
    h4=uicontrol('Style','push','String','SAVE DATA',...
        'Units','Normalized','Position',[0.013 0.8 0.14 0.06],...
        'Callback','Program_MOTOR save','Tag','save',...
        'FontWeight','bold','Fontsize',15);
        setpixelposition(h4,[15 459+2+250-200 180 45]);
    % MAP 
    h5=uicontrol('Style','push','String','TORQUE MAP',...
        'Units','Normalized','Position',[0.013 0.8 0.14 0.06],...
        'Callback','Program_MOTOR map','Tag','map',...
        'FontWeight','bold','Fontsize',15);
        setpixelposition(h5,[15 459+2+250-100 180 45]);
    % SAVE 
    h6=uicontrol('Style','push','String','SPEED CHAR.',...
        'Units','Normalized','Position',[0.013 0.8 0.14 0.06],...
        'Callback','Program_MOTOR char','Tag','char',...
        'FontWeight','bold','Fontsize',15);
        setpixelposition(h6,[15 459+2+250-150 180 45]);
    % Frekvence 
    h7=uicontrol('Style','push','String','NATURAL FREQ.',...
        'Units','Normalized','Position',[0.013 0.8 0.14 0.06],...
        'Callback','Program_MOTOR fre','Tag','fre',...
        'FontWeight','bold','Fontsize',15);
        setpixelposition(h7,[15 459+2+250-250 180 45]);
%% Output Help
    % Help
    Text1=uicontrol('Units','Normalized','Style','Edit',...
        'Position',[0.67 0.15 0.06 0.05],'String','-','Tag','Text1',...
        'ForegroundColor',[228/255 50/255 43/255],'BackgroundColor',[1 1 1],...
        'FontWeight','bold','Fontsize',15);
        setpixelposition(Text1,[15 459+2+200 180 45]);
%% Output Values
    % F1
    Text2=uicontrol('Units','Normalized','Style','Edit',...
        'Position',[0.67 0.15 0.06 0.05],'String','-','Tag','Text2',...
        'ForegroundColor','black','BackgroundColor',[1 1 1],...
        'FontWeight','bold','Fontsize',15);
        setpixelposition(Text2,[75 459+2-100 120 45]);
    % F2
    Text3=uicontrol('Units','Normalized','Style','Edit',...
        'Position',[0.67 0.15 0.06 0.05],'String','-','Tag','Text3',...
        'ForegroundColor','black','BackgroundColor',[1 1 1],...
        'FontWeight','bold','Fontsize',15);
        setpixelposition(Text3,[75 459+2-150 120 45]);
    % F3
    Text4=uicontrol('Units','Normalized','Style','Edit',...
        'Position',[0.67 0.15 0.06 0.05],'String','-','Tag','Text4',...
        'ForegroundColor','black','BackgroundColor',[1 1 1],...
        'FontWeight','bold','Fontsize',15);
        setpixelposition(Text4,[75 459+2-200 120 45]);
    % F4
    Text5=uicontrol('Units','Normalized','Style','Edit',...
        'Position',[0.67 0.15 0.06 0.05],'String','-','Tag','Text5',...
        'ForegroundColor','black','BackgroundColor',[1 1 1],...
        'FontWeight','bold','Fontsize',15);
        setpixelposition(Text5,[75 459+2-250 120 45]);
    % F5
    Text6=uicontrol('Units','Normalized','Style','Edit',...
        'Position',[0.67 0.15 0.06 0.05],'String','-','Tag','Text6',...
        'ForegroundColor','black','BackgroundColor',[1 1 1],...
        'FontWeight','bold','Fontsize',15);
        setpixelposition(Text6,[75 459+2-300 120 45]);
    % F6
    Text7=uicontrol('Units','Normalized','Style','Edit',...
        'Position',[0.67 0.15 0.06 0.05],'String','-','Tag','Text7',...
        'ForegroundColor','black','BackgroundColor',[1 1 1],...
        'FontWeight','bold','Fontsize',15);
        setpixelposition(Text7,[75 459+2-350 120 45]);
%% Input Torsion Stiffnes
    % c1
    Edit1=uicontrol('Units','Normalized','Style','Edit','String','50000',...
        'Position',[0.17 0.1 0.06 0.05],'Tag','Edit1',...
        'ForegroundColor','white','BackgroundColor',[228/255 50/255 43/255],...
        'FontWeight','bold','Fontsize',12,...
        'Callback','Program_DYN(''Edit1'')');
        setpixelposition(Edit1,[400 600 100 50]);
    % c2   
    Edit2=uicontrol('Units','Normalized','Style','Edit','String','1800000',...
        'Position',[0.17 0.1 0.06 0.05],'Tag','Edit2',...
        'ForegroundColor','white','BackgroundColor',[228/255 50/255 43/255],...
        'FontWeight','bold','Fontsize',12,...
        'Callback','Program_DYN(''Edit2'')');
        setpixelposition(Edit2,[550 600 100 50]);
    % c3      
    Edit3=uicontrol('Units','Normalized','Style','Edit','String','1500000',...
        'Position',[0.17 0.1 0.06 0.05],'Tag','Edit3',...
        'ForegroundColor','white','BackgroundColor',[228/255 50/255 43/255],...
        'FontWeight','bold','Fontsize',12,...
        'Callback','Program_DYN(''Edit3'')');
        setpixelposition(Edit3,[700 600 100 50]);
    % c4      
    Edit4=uicontrol('Units','Normalized','Style','Edit','String','1500000',...
        'Position',[0.17 0.1 0.06 0.05],'Tag','Edit4',...
        'ForegroundColor','white','BackgroundColor',[228/255 50/255 43/255],...
        'FontWeight','bold','Fontsize',12,...
        'Callback','Program_DYN(''Edit4'')');
        setpixelposition(Edit4,[850 600 100 50]);
    % c5     
    Edit5=uicontrol('Units','Normalized','Style','Edit','String','1500000',...
        'Position',[0.17 0.1 0.06 0.05],'Tag','Edit5',...
        'ForegroundColor','white','BackgroundColor',[228/255 50/255 43/255],...
        'FontWeight','bold','Fontsize',12,...
        'Callback','Program_DYN(''Edit5'')');
        setpixelposition(Edit5,[1000 600 100 50]);
    % c6     
    Edit6=uicontrol('Units','Normalized','Style','Edit','String','8000000',...
        'Position',[0.17 0.1 0.06 0.05],'Tag','Edit6',...
        'ForegroundColor','white','BackgroundColor',[228/255 50/255 43/255],...
        'FontWeight','bold','Fontsize',12,...
        'Callback','Program_DYN(''Edit6'')');
        setpixelposition(Edit6,[1150 600 100 50]);

%% Input Values
    % J1
    Edit7=uicontrol('Units','Normalized','Style','Edit','String','0.06',...
        'Position',[0.17 0.1 0.06 0.05],'Tag','Edit7',...
        'ForegroundColor','white','BackgroundColor',[228/255 50/255 43/255],...
        'FontWeight','bold','Fontsize',16,...
        'Callback','Program_DYN(''Edit7'')');
        setpixelposition(Edit7,[350-25 150 100 50]);
    % J2
        Edit8=uicontrol('Units','Normalized','Style','Edit','String','0.04',...
        'Position',[0.17 0.1 0.06 0.05],'Tag','Edit8',...
        'ForegroundColor','white','BackgroundColor',[228/255 50/255 43/255],...
        'FontWeight','bold','Fontsize',16,...
        'Callback','Program_DYN(''Edit8'')');
        setpixelposition(Edit8,[500-25 150 100 50]);
    % J3 
        Edit9=uicontrol('Units','Normalized','Style','Edit','String','0.11',...
        'Position',[0.17 0.1 0.06 0.05],'Tag','Edit9',...
        'ForegroundColor','white','BackgroundColor',[228/255 50/255 43/255],...
        'FontWeight','bold','Fontsize',16,...
        'Callback','Program_DYN(''Edit9'')');
        setpixelposition(Edit9,[650-25 150 100 50]);
    % J4 
        Edit10=uicontrol('Units','Normalized','Style','Edit','String','0.11',...
        'Position',[0.17 0.1 0.06 0.05],'Tag','Edit10',...
        'ForegroundColor','white','BackgroundColor',[228/255 50/255 43/255],...
        'FontWeight','bold','Fontsize',16,...
        'Callback','Program_DYN(''Edit10'')');
        setpixelposition(Edit10,[800-25 150 100 50]);
    % J5
        Edit11=uicontrol('Units','Normalized','Style','Edit','String','0.11',...
        'Position',[0.17 0.1 0.06 0.05],'Tag','Edit11',...
        'ForegroundColor','white','BackgroundColor',[228/255 50/255 43/255],...
        'FontWeight','bold','Fontsize',16,...
        'Callback','Program_DYN(''Edit11'')');
        setpixelposition(Edit11,[950-25 150 100 50]);
    % J6
        Edit12=uicontrol('Units','Normalized','Style','Edit','String','0.11',...
        'Position',[0.17 0.1 0.06 0.05],'Tag','Edit12',...
        'ForegroundColor','white','BackgroundColor',[228/255 50/255 43/255],...
        'FontWeight','bold','Fontsize',16,...
        'Callback','Program_DYN(''Edit12'')');
        setpixelposition(Edit12,[1100-25 150 100 50]);
    % J7 
        Edit13=uicontrol('Units','Normalized','Style','Edit','String','2.7',...
        'Position',[0.17 0.1 0.06 0.05],'Tag','Edit13',...
        'ForegroundColor','white','BackgroundColor',[228/255 50/255 43/255],...
        'FontWeight','bold','Fontsize',16,...
        'Callback','Program_DYN(''Edit13'')');
        setpixelposition(Edit13,[1250-25 150 100 50]);

   else
    switch(vstpar)
        case('load')
%% Read data
filterSpec={'*.*',  'All Files (*.*)'};     
dialogTitle='Select the data-file';
[fileName,pathName] = uigetfile(filterSpec,dialogTitle,defaultName);
fullFileName=[pathName,fileName];           

if fileName==0;
    return;
end;

%%
    for u=1:13
        switch u
            case 1
                A=800;
                snizeni=1;
                snizeni2=50;
            case 2
                A=900;
                snizeni=55;
                snizeni2=50;
            case 3
                A=1000;
                snizeni=57;
                snizeni2=50;
            case 4
                A=1100;
                snizeni=60;
                snizeni2=50;
            case 5
                A=1200;
                snizeni=62;
                snizeni2=50;
            case 6
                A=1300;
                snizeni=65;
                snizeni2=50;
            case 7
                A=1400;
                snizeni=68;
                snizeni2=50;
            case 8
                A=1500;
                snizeni=69;
                snizeni2=50;
            case 9
                A=1600;
                snizeni=70;
                snizeni2=50;
            case 10
                A=1700;
                snizeni=70;
                snizeni2=50;
            case 11
                A=1800;
                snizeni=70;
                snizeni2=50;
            case 12
                A=1900;
                snizeni=70;
                snizeni2=50;
            case 13
                A=2000;
                snizeni=70;
                snizeni2=50;
         end
    [NM,Mmean,Pm,Mmean1,Pm1,Fp,Mk]=Torque(A,snizeni,snizeni2,fullFileName);
    MOM1(u,:,2) = NM.V1v;
    MOM2(u,:,2) = NM.V2v;
    MOM3(u,:,2) = NM.V3v;
    MOM4(u,:,2) = NM.V4v;
    MOM5(u,:,2) = NM.V5v;
    MOM6(u,:,2) = NM.V6v;
    MOM7(u,:,2) = NM.V7v;
    MOM8(u,:,2) = NM.V8v;
    
    MOM1(u,:,1) = NM.V1vb;
    MOM2(u,:,1) = NM.V2vb;
    MOM3(u,:,1) = NM.V3vb;
    MOM4(u,:,1) = NM.V4vb;
    MOM5(u,:,1) = NM.V5vb;
    MOM6(u,:,1) = NM.V6vb;
    MOM7(u,:,1) = NM.V7vb;
    MOM8(u,:,1) = NM.V8vb;
    
    OCH(1,u)=Mmean;
    OCH(2,u)=Pm;
    OT(1,u)=A;
    end

%% Mechanical losses
nm=800:100:2000;                % [1/min]
omgC=2*pi*nm/60;                % [rad/s]
omgR=0;                         % [rad/s]
k.kmzt=0.12;                    % [N*m*s/rad]
k.kml1=k.kmzt;                  % [N*m*s/rad]
k.kml2=k.kmzt;                  % [N*m*s/rad]
k.kml3=k.kmzt;                  % [N*m*s/rad]
k.kml4=k.kmzt;                  % [N*m*s/rad]
k.kml5=k.kmzt;                  % [N*m*s/rad]
Mmz1=k.kml1*(omgR-omgC);        % [N*m]
Mmz2=k.kml2*(omgR-omgC);        % [N*m]
Mmz3=k.kml3*(omgR-omgC);        % [N*m]
Mmz4=k.kml4*(omgR-omgC);        % [N*m]
Mmz5=k.kml5*(omgR-omgC);        % [N*m]
Mmz=Mmz1+Mmz2+Mmz3+Mmz4+Mmz5;

OCHZ(1,:)=OCH(1,:)+Mmz;
OCHZ(2,:)=OCH(2,:)+(-Mmz.*(omgR-omgC)/1000);
set(findobj('Tag','Text1'),'String','Data found');

        case('save')
%% SAVE
            if  MOM1==0

set(findobj('Tag','Text1'),'String','Data are missing');
set(findobj('Tag','Text2'),'String','-');
set(findobj('Tag','Text3'),'String','-');
set(findobj('Tag','Text4'),'String','-');
set(findobj('Tag','Text5'),'String','-');
set(findobj('Tag','Text6'),'String','-');
set(findobj('Tag','Text7'),'String','-');
            else
save ('MOM1.mat','MOM1')
save ('MOM2.mat','MOM2')
save ('MOM3.mat','MOM3')
save ('MOM4.mat','MOM4')
save ('MOM5.mat','MOM5')
save ('MOM6.mat','MOM6')
save ('MOM7.mat','MOM7')
save ('MOM8.mat','MOM8')

load MOM1.mat
load MOM2.mat
load MOM3.mat
load MOM4.mat
load MOM5.mat
load MOM6.mat
load MOM7.mat
load MOM8.mat

set(findobj('Tag','Text1'),'String','Data save');
set(findobj('Tag','Text2'),'String','-');
set(findobj('Tag','Text3'),'String','-');
set(findobj('Tag','Text4'),'String','-');
set(findobj('Tag','Text5'),'String','-');
set(findobj('Tag','Text6'),'String','-');
set(findobj('Tag','Text7'),'String','-');

            end

        case('map')
%% GRAPH 1

            if  MOM1==0
                
               
set(findobj('Tag','Text1'),'String','Data are missing');

set(findobj('Tag','Text2'),'String','-');
set(findobj('Tag','Text3'),'String','-');
set(findobj('Tag','Text4'),'String','-');
set(findobj('Tag','Text5'),'String','-');
set(findobj('Tag','Text6'),'String','-');
set(findobj('Tag','Text7'),'String','-');
                           
            else
set(Edit1,'Visible','off')
set(Edit2,'Visible','off')
set(Edit3,'Visible','off')
set(Edit4,'Visible','off')
set(Edit5,'Visible','off')
set(Edit6,'Visible','off')
set(Edit7,'Visible','off')
set(Edit8,'Visible','off')
set(Edit9,'Visible','off')
set(Edit10,'Visible','off')
set(Edit11,'Visible','off')
set(Edit12,'Visible','off')
set(Edit13,'Visible','off')
set(t2,'Visible','off')
set(t3,'Visible','off')
set(t4,'Visible','off')

ee1=MOM4(:,:,1);
ee2=MOM4(:,:,2);
% 
su1=subplot(1,2,1:2);
setpixelposition(su1,[300 100 1100 600]);
surf(ee1,'FaceColor',[100/255 100/255 100/255],'EdgeColor','black');
hold on
view([-10 26])
surf(ee2,'FaceColor',[228/255 50/255 43/255],'EdgeColor','black');
zlabel('Torque [Nm]','fontsize',16,'fontweight','b','color','black')
title('Torque map','fontsize',24,'fontweight','b','color','black')
text(270,-2,-3000,'Crank angle [deg]','fontsize',16,'fontweight','b','color','black')
text(-70,11,-3000,'Engine speed [rpm]','fontsize',16,'fontweight','b','color','black','rotation',-50)
set(gca,'LineWidth',1)         
set(gca,'FontWeight','bold')   
set(gca,'FontSize',12)         
grid on
set(gca,'YTickLabels',800:100:2000)
axis([0 720 1 13 -3000 6000])
legend('Torque, min. fuel supply','Torque, max. fuel supply')
rect = [0.22, 0.72, .25, .1];
set(legend, 'Position', rect,'FontSize',14,'LineWidth',3)
set(gca,'XTick',0:90:720)
set(gca,'YTick',1:1:13)
hold off

set(findobj('Tag','Text2'),'String','-');
set(findobj('Tag','Text3'),'String','-');
set(findobj('Tag','Text4'),'String','-');
set(findobj('Tag','Text5'),'String','-');
set(findobj('Tag','Text6'),'String','-');
set(findobj('Tag','Text7'),'String','-');
set(findobj('Tag','Text1'),'String','Torque Map');

%% SAVE
set(gcf,'Units','pixels');
scrpos = get(gcf,'Position');
newpos = scrpos/96;
set(gcf,'PaperUnits','inches',...
'PaperPosition',newpos)
print(F1,'-dpng ',[defaultName,'\','TorqueMap','.png'],'-r100')

            end
        case('char')
%% GRAPH 2
            if  MOM1==0
set(findobj('Tag','Text1'),'String','Data are missing');

set(findobj('Tag','Text2'),'String','-');
set(findobj('Tag','Text3'),'String','-');
set(findobj('Tag','Text4'),'String','-');
set(findobj('Tag','Text5'),'String','-');
set(findobj('Tag','Text6'),'String','-');
set(findobj('Tag','Text7'),'String','-');
                            else

set(Edit1,'Visible','off')
set(Edit2,'Visible','off')
set(Edit3,'Visible','off')
set(Edit4,'Visible','off')
set(Edit5,'Visible','off')
set(Edit6,'Visible','off')
set(Edit7,'Visible','off')
set(Edit8,'Visible','off')
set(Edit9,'Visible','off')
set(Edit10,'Visible','off')
set(Edit11,'Visible','off')
set(Edit12,'Visible','off')
set(Edit13,'Visible','off')
set(t2,'Visible','off')
set(t3,'Visible','off')
set(t4,'Visible','off')

su2=subplot(1,2,1);
setpixelposition(su2,[300 100 500 600]);

% Measurement
Vyk30=[110 160 218 248 270 280 295 310 318 325 325];
Mome30=[1290 1650 2070 2100 2100 2050 2000 1950 1900 1850 1750];
Otac=(800:100:1800);

plot(OT,OCH(1,:),'Color',[150/255 150/255 150/255],'LineWidth', 3);
hold on
plot(OT,OCHZ(1,:),'Color',[228/255 50/255 43/255],'LineWidth', 3);
plot(Otac,Mome30,'Color',[0/255 0/255 0/255],'LineWidth', 3);
axis([800 max(OT) 600 2300])
title('Torque','fontsize',24,'fontweight','b','color','black')
xlabel('Engine speed [rpm]','fontsize',16,'fontweight','b','color','black')
ylabel('Torque [Nm]','fontsize',16,'fontweight','b','color','black')
set(gca,'LineWidth',1)         
set(gca,'FontWeight','bold')   
set(gca,'FontSize',12)         
grid on
legend('SIMULATION - no mechanical losses (Torque)','SIMULATION - mechanical losses (Torque)','MEASUREMENT - dynamometer (torque)')
rect = [0.25, 0.18, .25, .1];
set(legend, 'Position', rect,'FontSize',14,'LineWidth',3)
set(gca,'XTick',800:100:2000)
set(gca,'YTick',700:100:2300)


su3=subplot(1,2,2);
setpixelposition(su3,[900 100 500 600]);
plot(OT,OCH(2,:),'Color',[150/255 150/255 150/255],'LineWidth', 3)
hold on
plot(OT,OCHZ(2,:),'Color',[228/255 50/255 43/255],'LineWidth', 3)
plot(Otac,Vyk30,'Color',[0/255 0/255 0/255],'LineWidth', 3)
axis([800 max(OT) 70 360])
title('Engine power','fontsize',24,'fontweight','b','color','black')
xlabel('Engine speed [rpm]','fontsize',16,'fontweight','b','color','black')
ylabel('Power [kW]','fontsize',16,'fontweight','b','color','black')
set(gca,'LineWidth',1)         
set(gca,'FontWeight','bold')   
set(gca,'FontSize',12)         
grid on
legend('SIMULATION - no mechanical losses (Power)','SIMULATION - mechanical losses (Power)','MEASUREMENT - dynamometer (Power)')
rect = [0.65, 0.18, .25, .1];
set(legend, 'Position', rect,'FontSize',14,'LineWidth',3)
set(gca,'XTick',800:100:2000)
set(gca,'YTick',80:20:360)
hold off  

set(findobj('Tag','Text2'),'String','-');
set(findobj('Tag','Text3'),'String','-');
set(findobj('Tag','Text4'),'String','-');
set(findobj('Tag','Text5'),'String','-');
set(findobj('Tag','Text6'),'String','-');
set(findobj('Tag','Text7'),'String','-');
set(findobj('Tag','Text1'),'String','Speed Char.');
%% SAVE
set(gcf,'Units','pixels');
scrpos = get(gcf,'Position');
newpos = scrpos/96;
set(gcf,'PaperUnits','inches',...
'PaperPosition',newpos)
print(F1,'-dpng ',[defaultName,'\','SpeedChar','.png'],'-r100')

            end

        case('fre')
%%
set(Edit1,'Visible','on')
set(Edit2,'Visible','on')
set(Edit3,'Visible','on')
set(Edit4,'Visible','on')
set(Edit5,'Visible','on')
set(Edit6,'Visible','on')
set(Edit7,'Visible','on')
set(Edit8,'Visible','on')
set(Edit9,'Visible','on')
set(Edit10,'Visible','on')
set(Edit11,'Visible','on')
set(Edit12,'Visible','on')
set(Edit13,'Visible','on')
set(t2,'Visible','on')
set(t3,'Visible','on')
set(t4,'Visible','on')
% Picture
    I=imread('obr.bmp');

        o1=subplot(1,2,1:2);
        image(I);
        axis off;
        setpixelposition(o1,[385 130 865 516]);
        
k12=str2double(get(findobj('Tag','Edit1'),'String'));
k23=str2double(get(findobj('Tag','Edit2'),'String'));
k34=str2double(get(findobj('Tag','Edit3'),'String'));
k45=str2double(get(findobj('Tag','Edit4'),'String'));
k56=str2double(get(findobj('Tag','Edit5'),'String'));
k67=str2double(get(findobj('Tag','Edit6'),'String'));
I1=str2double(get(findobj('Tag','Edit7'),'String'));
I2=str2double(get(findobj('Tag','Edit8'),'String'));
I3=str2double(get(findobj('Tag','Edit9'),'String'));
I4=str2double(get(findobj('Tag','Edit10'),'String'));
I5=str2double(get(findobj('Tag','Edit11'),'String'));
I6=str2double(get(findobj('Tag','Edit12'),'String'));
I7=str2double(get(findobj('Tag','Edit13'),'String'));

%% 
M=[I1 0 0 0 0 0 0;...
    0 I2 0 0 0 0 0;...
    0 0 I3 0 0 0 0;...
    0 0 0 I4 0 0 0;...
    0 0 0 0 I5 0 0;...
    0 0 0 0 0 I6 0;...
    0 0 0 0 0 0 I7];
%%
K=[k12 -k12 0 0 0 0 0;...
    -k12 (k12+k23) -k23 0 0 0 0;...
    0 -k23 (k23+k34) -k34 0 0 0;...
    0 0 -k34 (k34+k45) -k45 0 0;...
    0 0 0 -k45 (k45+k56) -k56 0;...
    0 0 0 0 -k56 (k56+k67) -k67;...
    0 0 0 0 0 -k67 k67];
%%
As=M^-1*K;
[a,b]=eig(As);
OMG=real(diag((b).^(1/2)));
fvl=OMG/(2*pi);
fvl2=sort(fvl);
fvl3=fvl2(end:-1:1);
fvl3(2,1)

set(findobj('Tag','Text2'),'String',num2str(sprintf('%5.2f',fvl3(1,1))));
set(findobj('Tag','Text3'),'String',num2str(sprintf('%5.2f',fvl3(2,1))));
set(findobj('Tag','Text4'),'String',num2str(sprintf('%5.2f',fvl3(3,1))));
set(findobj('Tag','Text5'),'String',num2str(sprintf('%5.2f',fvl3(4,1))));
set(findobj('Tag','Text6'),'String',num2str(sprintf('%5.2f',fvl3(5,1))));
set(findobj('Tag','Text7'),'String',num2str(sprintf('%5.2f',fvl3(6,1))));
set(findobj('Tag','Text1'),'String','Natural frequency');
%% SAVE
set(gcf,'Units','pixels');
scrpos = get(gcf,'Position');
newpos = scrpos/96;
set(gcf,'PaperUnits','inches',...
'PaperPosition',newpos)
print(F1,'-dpng ',[defaultName,'\','NaturalFrequency','.png'],'-r100')
           
        case('close')
%%         
            clear all
            clc
            close all 
    end
end